﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CommTest
{
    public partial class Form1 : Form
    {
        // Used to pass rx data.  
        //  For production code, QCI 
        //  suggests using a cicular queue
        string strRx;

        // Constructor
        public Form1()
        {
            InitializeComponent();
        }

        // Configure COM when form opens
        private void Form1_Load(
            object sender, EventArgs e)
        {
            ConfigureCOM();
        }
        private void ConfigureCOM()
        {
            serialPort1.PortName = "COM1";
            serialPort1.BaudRate = 57600;
            serialPort1.Open();
        }
        // Close COM port when form closes
        private void Form1_FormClosing(
            object sender, FormClosingEventArgs e)
        {
            if (serialPort1.IsOpen) serialPort1.Close();
        }
        // Send MRT when Test pressed
        private void cmdTest_Click(
            object sender, EventArgs e)
        {
            // send move relative, time based(mrt)
            //  mrt 40000 count, 
            //  100ms ramp time, 1000ms total time
            string strCmd = "@16 177 40000 833 8333 0 0 \r";
            serialPort1.Write(strCmd);

            // Write to textBox1
            textBox1.AppendText("\n");
            textBox1.AppendText(strCmd);
            textBox1.AppendText("\n");
        }
        // Display controller response in text box.
        private void DisplayText(object sender, EventArgs e)
        {
            textBox1.AppendText(strRx);
        }
        private void serialPort1_DataReceived(
            object sender,
            System.IO.Ports.SerialDataReceivedEventArgs e)
        {
            strRx = serialPort1.ReadExisting();
            this.Invoke(new EventHandler(DisplayText));
        }
    }
}
