// MakeCirclesDlg.h : header file
//
//{{AFX_INCLUDES()
//}}AFX_INCLUDES

#if !defined(AFX_MSCOMMTESTDLG_H__CDA77188_6833_11D3_9D83_444553540000__INCLUDED_)
#define AFX_MSCOMMTESTDLG_H__CDA77188_6833_11D3_9D83_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

/////////////////////////////////////////////////////////////////////////////
// CMakeCirclesDlg dialog


class CMakeCirclesDlg : public CDialog
{
// Construction
public:
    CMakeCirclesDlg(CWnd* pParent = NULL);  // standard constructor

// Dialog Data
    //{{AFX_DATA(CMakeCirclesDlg)
	enum { IDD = IDD_MAKECIRCLES_DIALOG };
    CSliderCtrl m_jogYaxis;
    CSliderCtrl m_jogXaxis;
    CButton m_COM2;
    CButton m_COM1;
    UINT    m_XaxisID;
    UINT    m_YaxisID;
	//}}AFX_DATA

    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CMakeCirclesDlg)
    protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    virtual void PostNcDestroy();
    //}}AFX_VIRTUAL

// Implementation
protected:
    HICON m_hIcon;

    // Generated message map functions
    //{{AFX_MSG(CMakeCirclesDlg)
    virtual BOOL OnInitDialog();
    afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
    afx_msg void OnPaint();
    afx_msg HCURSOR OnQueryDragIcon();
    afx_msg void OnCom1();
    afx_msg void OnCom2();
    afx_msg void OnSetupcircle();
    afx_msg void OnDomove();
    afx_msg void OnRestart();
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnStop();
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnGotocenter();
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()


    ///////////////
    // Members 
    ///////////////
    public:
    HANDLE m_hComm;                     // Windows Handle to Comm Port "File"

    // Circular Interpolation Tables (CIT)
    long m_motorTime[MAXSEGMENTS];
    long m_motorVelX[MAXSEGMENTS];
    long m_motorVelY[MAXSEGMENTS];
    long m_motorAccX[MAXSEGMENTS];
    long m_motorAccY[MAXSEGMENTS];
    long m_motorPosX[MAXSEGMENTS];
    long m_motorPosY[MAXSEGMENTS];

    long m_numCITSegments;              // Number of segments in CIT 
    bool m_bCITCalculated;              // CIT has been calculated

    // Circle Parameters
    float   m_maxVel;                   // Max Tangential Velocity 
    float   m_radius;                   // Circle Radius
    float   m_startAngle;               // Starting Angle (degrees)
    float   m_distanceAngle;            // Arc length to scribe (degrees)
    
                                        // X Axis Members
    float   m_XOffset;                  // Offset
    long    m_XScaleFactor;             // Scale Factor (counts/engineering unit)
    long    m_XMaxVel;                  // Max Velocity
    long    m_XMaxAcc;                  // Max Acceleration

                                        // Y Axis Members
    float   m_YOffset;                  // Offset
    long    m_YScaleFactor;             // Scale Factor
    long    m_YMaxVel;                  // Max Velocity 
    long    m_YMaxAcc;                  // Max Acceleration

    bool m_bCommEnabled;                // Comm Port has been enabled

    ///////////////
    // Attributes
    ///////////////
    public:

    ///////////////
    // Methods
    ///////////////
    public:
    // This procedure sends ASCII
    int SendCommand( char * CommandString, bool ACK);
    void ConfigureCOM(CString strCommPort);
    void OnComX(int commPortNum);
};



//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.


#endif // !defined(AFX_MSCOMMTESTDLG_H__CDA77188_6833_11D3_9D83_444553540000__INCLUDED_)

