VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmLRPPOLRRG 
   Caption         =   "LRP, POL and RRG"
   ClientHeight    =   1665
   ClientLeft      =   5505
   ClientTop       =   4455
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   1665
   ScaleWidth      =   4680
   Begin VB.Timer tmrDelay 
      Interval        =   1
      Left            =   2640
      Top             =   1080
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   1680
      Top             =   1080
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      StopBits        =   2
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   495
      Left            =   120
      TabIndex        =   1
      Top             =   1080
      Width           =   1215
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   3360
      TabIndex        =   0
      Top             =   1080
      Width           =   1215
   End
   Begin VB.Label lblResponse 
      BackColor       =   &H80000009&
      BorderStyle     =   1  'Fixed Single
      Height          =   975
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   4695
   End
End
Attribute VB_Name = "frmLRPPOLRRG"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim currentTime As Single
Dim bDone As Boolean
Dim strIn As String
Dim strInMod As String
Dim intstrInMod As Integer
Dim intMask As Integer
Dim strOut As String

Private Sub cmdExit_Click()

    ' close the serial port
    MSComm1.PortOpen = False
    End
   
End Sub

Private Sub cmdStart_Click()
   
    ' Send CPL Command, clears the polling status word
    strOut = "@16 1 8192" & Chr(13)
    MSComm1.Output = strOut
    Call delay
    strIn = MSComm1.Input

    ' Send LRP Command, runs program 512
    strOut = "@16 156 512" & Chr(13)
    MSComm1.Output = strOut
    Call delay
    strIn = MSComm1.Input ' Get response from Device ex:"* 10"
    ' Display response
    lblResponse.Caption = "LRP Response: " & strIn
        
    Do While bDone = False ' ends when bDone is true
   
        ' Send POR Command, this command retrieves the polling status word
        strOut = "@16 27" & Chr(13)
        MSComm1.Output = strOut
        Call delay
        strIn = MSComm1.Input ' Get response from Device ex:"# 10 001B 2000 "
        
        strInMod = Right$(strIn, 5) ' only take last 5 bytes ex:"2000 "
        strInMod = "&H" & strInMod ' declares value as hex
        intstrInMod = Val(strInMod) ' takes value of string
        intMask = &H2000 ' value being looked for
        
        If (intstrInMod And intMask) = &H2000 Then ' bitwise And compare
            bDone = True
            ' Display response
            lblResponse.Caption = lblResponse.Caption & "Bit 13 found" & Chr(13)
        End If
   
    Loop
    bDone = False
      
    ' Send RRG Command, this reads the (1) register and returns as a decimal value
    ' NOTE   see QCI-TD053 for details on using the '/' character on an out
    '        going packets to have the response packet return decimal formatted data.
    '        (only for SilverDust firmware rev 12+)
    strOut = "|16 12 1" & Chr(13)
    MSComm1.Output = strOut ' sends the command to the controller
    Call delay
    strIn = MSComm1.Input ' Get response from Device ex:"/ 16 12 8000 "
    ' Display response
    lblResponse.Caption = lblResponse.Caption & "RRG Response:  " & strIn

End Sub

Function delay()

    ' delay to give device time to respond
    Dim delayTime As Single
    delayTime = currentTime + 25
    Do
       DoEvents      ' needed so that timer will update
                     ' while we are in this loop
    Loop Until (currentTime >= delayTime)
   
End Function

Private Sub Form_Load()

    '  Setup and open COM Port 1
    MSComm1.CommPort = 1
    MSComm1.Settings = "57600,N,8,2"
    MSComm1.InputLen = 0
    MSComm1.PortOpen = True
   
End Sub

Private Sub tmrDelay_Timer()

    currentTime = currentTime + 1
   
End Sub
